
#ifndef _PLAYBACK_H_
#define _PLAYBACK_H_

#include "Types.h"

typedef enum { reset, stopped, playing, paused, error } playback_state_t;
typedef enum { ok, sd_card_invalid_response, sd_card_wrong_voltage, sd_card_timeout, fat_mount_failed, open_root_dir_failed, config_file_invalid, no_wav_files, invalid_wav_file, invalid_wav_format, file_read_error, max_depth_exceeded } playback_error_t;
typedef enum { directory, sorted, shuffle } playback_order_t;

#define ERROR_NOT_SDMMC_CARD		1
#define ERROR_BAD_VOLTAGE_RANGE	  	2
#define ERROR_SDMMC_CARD_TIMEOUT	3

static inline unsigned char is_wav_ext(const char* ext) {
	return (ext[1] == 'w' || ext[1] == 'W') && (ext[2] == 'a' || ext[2] == 'A') && (ext[3] == 'v' || ext[3] == 'V') && ext[4] == '\0';
}


unsigned char Playback_Setup();
unsigned char Playback_Reset();
unsigned char Playback_Start();
unsigned char Playback_Stop();
unsigned char Playback_Pause();
unsigned char Playback_Next_Track(bool clear_buffer);
unsigned char Playback_Prev_Track(bool clear_buffer);
unsigned char Playback_Forward();
unsigned char Playback_Back();
unsigned char Playback_Set_Order(playback_order_t order);
unsigned char playback_volume_up();
unsigned char playback_volume_down();
unsigned char playback_volume_set(unsigned char percent);
unsigned char playback_toggle_mute();
playback_state_t Playback_Get_Status();
playback_error_t Playback_Get_Error();
playback_order_t Playback_Get_Order();
bool Playback_Get_Shuffle();
unsigned char Playback_Process();

unsigned char Playback_Get_Folder_Level();
unsigned char Playback_Next_Folder();
unsigned char Playback_Prev_Folder();
unsigned char Playback_Up_Folder();

#endif//_PLAYBACK_H_
